/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: SercosIII_SIP_Public.h 52414 2015-03-20 13:31:51Z DenisJ              $

   Description:
    SERCOSIII SIP Server Task

    Includes following functions:

   Changes:

     Date          Description
     ---------------------------------------------------------------------------
     2011-01-26    Created
*******************************************************************************/
/**
 * @file SIIISIP_Public.h
 *  SIII SIP - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 *
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 */
#ifndef __SIII_SIP_PUBLIC_H
#define __SIII_SIP_PUBLIC_H

/** queue name */
#define SIII_SIP_QUEUE_NAME   "QUE_SIII_SIP"

#define SIII_SIP_MAX_NUM_REQ  10

#define SIII_SIP_MAX_NUM_SOCKETS  2
#define SIII_SIP_MAX_NUM_SIP_CONNECTIONS  2

#define VAL_SIII_SIP_ATTR_IDN_IS_LIST                         0x00040000
/*
 * ******************************Begin Commom Hilscher Command Area******************************
 */
/*This command is used to tell the SIP Task that the IP-settings has changed*/
#define SIII_SIP_TASK_CMD_TCPIP_CONFIG_COMPLETE_IND                 0x00008000
#define SIII_SIP_TASK_CMD_TCPIP_CONFIG_COMPLETE_RES                 0x00008001
/*
 * ******************************End Commom Hilscher Command Area******************************
 */


/*************************************************************************************/
/*************************** Common Hilscher packet area******************************/
/*************************************************************************************/
/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__SIII_SIP_PACKET)
#endif


typedef struct SIII_SIP_TCPIP_CONFIG_CHANGED_IND_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} SIII_SIP_TCPIP_CONFIG_COMPLETE_IND_T;


typedef struct SIII_SIP_TCPIP_CONFIG_CHANGED_RES_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} SIII_SIP_TCPIP_CONFIG_COMPLETE_RES_T;

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__SIII_SIP_PACKET)
#endif


/*************************************************************************************/
#endif /* #ifndef __SIII_SIP_PUBLIC_H */
